﻿<%@ Page Language="c#" CodePage="1200" AutoEventWireup="false" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="Soneta.Ksiega" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Obroty konta miesięcznie</title>

	<script runat="server">


		private void ObrotyKontaMiesiecznie_OnLoad(Object sender, EventArgs args)
		{
			ObrotyKontaWorker.Params p = (ObrotyKontaWorker.Params) DataContext1.Get(typeof(ObrotyKontaWorker.Params));
			KontoBase konto = (KontoBase) DataContext1.Get(typeof(KontoBase));
			ObrotyKontaWorker okw = new ObrotyKontaWorker();
			//Na wydruku zawsze uwzględniane są dekrety zamknięcia
            p.DekretyZamkniecia = true;
			okw.Param = p;
			okw.Konto = konto;
			ReportHeader1.Title = string.Format(ReportHeader1.Title, konto.Okres, HttpUtility.HtmlEncode(konto.ToString()), p.Okres, p.Bufor ? "Tak" : "Nie", p.DekretyZamkniecia ? "Tak" : "Nie");
			Grid1.DataSource = okw.ObrotyMiesiecznie;
            labelSymbol.EditValue = konto.Symbol;
	         labelNazwa.EditValue = konto.Nazwa;
	        labelWaluta.EditValue = konto.Waluta;
		}

		
	</script>

</head>
<body>
	<form id="ObrotyKontaMiesiecznie" method="post" onload="ObrotyKontaMiesiecznie_OnLoad" runat="server">
	    <ea:DataContext id="DataContext1" runat="server" Landscape="True"/>
		<cc1:ReportHeader id="ReportHeader1" title="Obroty konta miesięcznie | Okres obrachunkowy: {0} | Konto: {1} | Za okres: {2} | Uwzględniać bufor: {3} | Uwzględniać dekrety zamknięcia: {4}" runat="server" />
         <TABLE width="100%" style="FONT-SIZE: x-small; FONT-FAMILY: Tahoma">
			<TR>
			  <TD align="left">
				<ea:DataLabel id="labelSymbol" runat="server" Font-Names="Tahoma" EncodeHTML="true" ></ea:DataLabel></TD>
			  <TD align="middle">
				<ea:DataLabel id="labelNazwa" runat="server" Font-Names="Tahoma" EncodeHTML="true" ></ea:DataLabel></TD>
			  <TD align="right">
				<ea:DataLabel id="labelWaluta" runat="server" Font-Names="Tahoma"></ea:DataLabel></TD>
			</TR>
		  </TABLE>
        <ea:Grid id="Grid1" runat="server" ShowPrevAgrSum="InFooter" ShowAgrSum="True" ShowPageSum="True">
			<columns>
					<ea:GridColumn Width="3" DataMember="#" Caption="Lp" ID="colLp"></ea:GridColumn>
					<ea:GridColumn Align="Center" Width="15" DataMember="Miesiąc" ID="colMiesiąc"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="SaldoPoczatkoweWinien" Caption="Saldo Pocz. Winien" Format="{0:n}" ID="colSaldoPoczWinien"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="SaldoPoczatkoweMa" Caption="Saldo Pocz. Ma" Format="{0:n}" ID="colSaldoPoczMa"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Winien" Format="{0:n}" ID="colWinien"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Ma" Format="{0:n}" ID="colMa"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="WinienN" Caption="Winien Narast." Format="{0:n}" ID="colWinienN"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="MaN" Caption="Ma Narast." Format="{0:n}" ID="colMaN"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="SaldoWinien" Caption="Saldo Winien" Format="{0:n}" ID="colSaldoWinien"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="SaldoMa" Caption="Saldo Ma" Format="{0:n}" ID="colSaldoMa"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="PerSaldo" Format="{0:n}" ID="colPerSaldo"></ea:GridColumn>
				</columns>
		</ea:Grid>
		<cc1:ReportFooter id="ReportFooter1" runat="server">
			<subtitles>
					<cc1:FooterSubtitle SubtitleType="Operator"></cc1:FooterSubtitle>
			</subtitles>
		</cc1:ReportFooter>
	</form>
</body>
</html>

